-- new script file

local waveFort = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("attFort")
  self:AddTriggerTarget("deactFort")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.counter = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
      self.active = false
      self.deact = false
    end
            
    mission.enemy = Citadels.GetPlayer(1)
    self.wayPoint1 = Game:GetEntity('shallows'):GetPosition()
    self.wayPoint2 = Game:GetEntity('meadowFort'):GetPosition()
    self.wayPoint3 = Game:GetEntity('fort'):GetPosition()
  end
  
  if self.active and not self.deact then
    InitializeWave(self)
    GenerateWaveAI(self)
    self.active = false
  end  
end

function InitializeWave(self)
  waveFort['unit_L_archer_L2'] = self.baseCount * 0.1
  waveFort['unit_L_rider_L1'] = self.baseCount * 0.06
  waveFort['unit_L_catapult_L1'] = self.baseCount * 0.02
end

function GenerateWaveAI(self)
  for prefab,ammount in pairs(waveFort) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint2)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint3)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(),20)
end

function OnTrigger(self, source, target)
  if target == "attFort" then
    self.active = true
  elseif target == "deactFort" then
	  self.deact = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.counter = ar:Read()
    self.baseCount = ar:Read()
    self.active = ar:Read()
    self.deact = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.counter)
    ar:Write(self.baseCount)
    ar:Write(self.active)
    ar:Write(self.deact)
  end
end